<?php
session_start();
require_once 'config/config.php';
require_once BASE_PATH . '/includes/auth_validate.php';

// Statistics class
require_once BASE_PATH . '/lib/Sites/Statistics.php';
$statistics = new Statistics();

// Get Input data from query string
$search_string = filter_input(INPUT_GET, 'search_string');
$from = filter_input(INPUT_GET, 'from');
$to = filter_input(INPUT_GET, 'to');
$filter_col = filter_input(INPUT_GET, 'filter_col');
$order_by = filter_input(INPUT_GET, 'order_by');

// Per page limit for pagination.
$pagelimit = 15;

// Get current page.
$page = filter_input(INPUT_GET, 'page');
if (!$page) {
	$page = 1;
}

// If filter types are not selected we show latest added data first
if (!$filter_col) {
	$filter_col = 'date';
}
if (!$order_by) {
	$order_by = 'Desc';
}

//Get DB instance. i.e instance of MYSQLiDB Library
$db = getDbInstance();
$select = array('date', 's.domain AS site', 'calls', 'views', 'sites_statistics.clicks AS clicks', 'no_lang', 'no_country', 'no_device', 'no_connectiontype', 'no_timerange');

$db->join("sites s", "site_id = id", "LEFT");

//Start building query according to input parameters.
// If search string
if ($search_string) {
	$db->where('s.domain', '%' . $search_string . '%', 'like');
}
if ($from) {
	$db->where('date', date("Y-m-d", strtotime($from)), '>=');
}
if ($to) {
	$db->where('date', date("Y-m-d", strtotime($to)), '<=');
}


//If order by option selected
if ($order_by) {
	$db->orderBy($filter_col, $order_by);
}

// Set pagination limit
$db->pageLimit = $pagelimit;

// Get result of the query.
$rows = $db->arraybuilder()->paginate('sites_statistics', $page, $select);
$total_pages = $db->totalPages;

include BASE_PATH . '/includes/header.php';
?>
<!-- Main container -->
<div id="page-wrapper">
    <div class="row">
        <div class="col-lg-6">
            <h1 class="page-header">Statistics</h1>
        </div>
    </div>
    <?php include BASE_PATH . '/includes/flash_messages.php';?>

    <!-- Filters -->
    <div class="well text-center filter-form">
        <form class="form form-inline" action="">
            <label for="input_search">Search</label>
            <input type="text" class="form-control" id="input_search" name="search_string" value="<?php echo xss_clean($search_string); ?>">
            <label for="input_from">From</label>
            <input type="text" class="form-control date-picker" id="input_from" name="from" value="<?php echo xss_clean($from); ?>">
            <label for="input_to">To</label>
            <input type="text" class="form-control date-picker" id="input_to" name="to" value="<?php echo xss_clean($to); ?>">
            <label for="input_order">Order By</label>
            <select name="filter_col" class="form-control">
                <?php
foreach ($statistics->setOrderingValues() as $opt_value => $opt_name):
	($order_by === $opt_value) ? $selected = 'selected' : $selected = '';
	echo ' <option value="' . $opt_value . '" ' . $selected . '>' . $opt_name . '</option>';
endforeach;
?>
            </select>
            <select name="order_by" class="form-control" id="input_order">
                <option value="Asc" <?php
if ($order_by == 'Asc') {
	echo 'selected';
}
?> >Asc</option>
                <option value="Desc" <?php
if ($order_by == 'Desc') {
	echo 'selected';
}
?>>Desc</option>
            </select>
            <input type="submit" value="Go" class="btn btn-primary">
        </form>
    </div>
    <hr>
    <!-- //Filters -->

    <!-- Table -->
    <table class="table table-striped table-bordered table-condensed">
        <thead>
            <tr>
                <th width="5%">Date</th>
                <th width="15%">Site</th>
                <th width="10%">Calls</th>
                <th width="10%">Views</th>
                <th width="10%">Clicks</th>
                <th width="10%">No Lang</th>
                <th width="10%">No Country</th>
                <th width="10%">No Device</th>
                <th width="10%">No Connection type</th>
                <th width="10%">No Time range</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($rows as $row): ?>
            <tr>
                <td><?php echo xss_clean(date('d/m/Y', strtotime($row['date']))); ?></td>
                <td><?php echo xss_clean($row['site']); ?></td>
                <td><?php echo xss_clean($row['calls']); ?></td>
                <td><?php echo xss_clean($row['views']); ?></td>
                <td><?php echo xss_clean($row['clicks']); ?></td>
                <td><?php echo xss_clean($row['no_lang']); ?></td>
                <td><?php echo xss_clean($row['no_country']); ?></td>
                <td><?php echo xss_clean($row['no_device']); ?></td>
                <td><?php echo xss_clean($row['no_connectiontype']); ?></td>
                <td><?php echo xss_clean($row['no_timerange']); ?></td>
            </tr>
            <?php endforeach;?>
        </tbody>
    </table>
    <!-- //Table -->

    <!-- Pagination -->
    <div class="text-center">
    <?php echo paginationLinks($page, $total_pages, 'sites_statistics.php'); ?>
    </div>
    <!-- //Pagination -->
</div>
<!-- //Main container -->
<?php include BASE_PATH . '/includes/footer.php';?>
