<?php
session_start();
require_once './config/config.php';
require_once 'includes/auth_validate.php';


// Sanitize if you want
$site_id = filter_input(INPUT_GET, 'site_id', FILTER_VALIDATE_INT);
$operation = filter_input(INPUT_GET, 'operation',FILTER_SANITIZE_STRING); 
($operation == 'edit') ? $edit = true : $edit = false;
 $db = getDbInstance();

//Handle update request. As the form's action attribute is set to the same script, but 'POST' method, 
if ($_SERVER['REQUEST_METHOD'] == 'POST') 
{
    //Get site id form query string parameter.
    $site_id = filter_input(INPUT_GET, 'site_id', FILTER_SANITIZE_STRING);

    //Get input data
    $data_to_update = filter_input_array(INPUT_POST);

    foreach($data_to_update as $key => $field)
        if(empty($data_to_update[$key]))
            $data_to_update[$key] = null;

    $data_to_update["enabled"] = $data_to_update["enabled"] ? 1 : 0;

    if(@$data_to_update["desktop"] == 1)
        $data_to_update["devices"] = "Desktop";
    if(@$data_to_update["tablet"] == 1)
    {
        if(@$data_to_update["devices"] != "")
            $data_to_update["devices"] .= ",";
        $data_to_update["devices"] .= "Tablet";
    }
    if(@$data_to_update["mobile"] == 1)
    {
        if(@$data_to_update["devices"] != "")
            $data_to_update["devices"] .= ",";
        $data_to_update["devices"] .= "Mobile";
    }
    unset($data_to_update["desktop"]);
    unset($data_to_update["tablet"]);
    unset($data_to_update["mobile"]);

    if(@$data_to_update["dialup"] == 1)
        $data_to_update["connection_types"] = "Dialup";
    if(@$data_to_update["cable"] == 1)
    {
        if(@$data_to_update["connection_types"] != "")
            $data_to_update["connection_types"] .= ",";
        $data_to_update["connection_types"] .= "Cable/DSL";
    }
    if(@$data_to_update["corporate"] == 1)
    {
        if(@$data_to_update["connection_types"] != "")
            $data_to_update["connection_types"] .= ",";
        $data_to_update["connection_types"] .= "Corporate";
    }
    if(@$data_to_update["cellular"] == 1)
    {
        if(@$data_to_update["connection_types"] != "")
            $data_to_update["connection_types"] .= ",";
        $data_to_update["connection_types"] .= "Cellular";
    }
    unset($data_to_update["dialup"]);
    unset($data_to_update["cable"]);
    unset($data_to_update["corporate"]);
    unset($data_to_update["cellular"]);

    $times_range_to_exclude = "";
    for($i = 0; $i < 5; $i++)
    {
        if($data_to_update["times_range_to_exclude_from"][$i] != "00:00" || $data_to_update["times_range_to_exclude_to"][$i] != "00:00")
        {
            if($times_range_to_exclude != "")
                $times_range_to_exclude .= ",";
            $times_range_to_exclude .= $data_to_update["times_range_to_exclude_from"][$i]."-".$data_to_update["times_range_to_exclude_to"][$i];
        }
    }
    if($times_range_to_exclude != "")
        $data_to_update["times_range_to_exclude"] = $times_range_to_exclude;
    else
        $data_to_update["times_range_to_exclude"] = null;
    unset($data_to_update["times_range_to_exclude_from"]);
    unset($data_to_update["times_range_to_exclude_to"]);
    unset($data_to_update["hour"]);
    unset($data_to_update["minute"]);

    $data_to_update["transparent"] = $data_to_update["transparent"] ? 1 : 0;

    $db = getDbInstance();
    $db->where('id',$site_id);
    $stat = $db->update('sites', $data_to_update);

    if($stat)
    {
        $_SESSION['success'] = "Site updated successfully!";
        //Redirect to the listing page,
        header('location: sites.php');
        //Important! Don't execute the rest put the exit/die. 
        exit();
    }
}


//If edit variable is set, we are performing the update operation.
if($edit)
{
    $db->where('id', $site_id);
    //Get data to pre-populate the form.
    $site = $db->getOne("sites");
}
?>


<?php
    include_once 'includes/header.php';
?>
<div id="page-wrapper">
    <div class="row">
        <h2 class="page-header">Update Site</h2>
    </div>
    <!-- Flash messages -->
    <?php
        include('./includes/flash_messages.php')
    ?>

    <form class="" action="" method="post" enctype="multipart/form-data" id="contact_form">
        
        <?php
            //Include the common form for add and edit  
            require_once('./forms/site_form.php'); 
        ?>
    </form>
</div>




<?php include_once 'includes/footer.php'; ?>