<?php
session_start();
require_once './config/config.php';
require_once './includes/auth_validate.php';


//serve POST method, After successful insert, redirect to sites.php page.
if ($_SERVER['REQUEST_METHOD'] === 'POST') 
{
    //Mass Insert Data. Keep "name" attribute in html form same as column name in mysql table.
    $data_to_store = array_filter($_POST);

    //Insert timestamp
    $data_to_store['created'] = date('Y-m-d H:i:s');
    
    if(@$data_to_store["desktop"] == 1)
        $data_to_store["devices"] = "Desktop";
    if(@$data_to_store["tablet"] == 1)
    {
        if(@$data_to_store["devices"] != "")
            $data_to_store["devices"] .= ",";
        $data_to_store["devices"] .= "Tablet";
    }
    if(@$data_to_store["mobile"] == 1)
    {
        if(@$data_to_store["devices"] != "")
            $data_to_store["devices"] .= ",";
        $data_to_store["devices"] .= "Mobile";
    }
    unset($data_to_store["desktop"]);
    unset($data_to_store["tablet"]);
    unset($data_to_store["mobile"]);

    if(@$data_to_store["dialup"] == 1)
        $data_to_store["connection_types"] = "Dialup";
    if(@$data_to_store["cable"] == 1)
    {
        if(@$data_to_store["connection_types"] != "")
            $data_to_store["connection_types"] .= ",";
        $data_to_store["connection_types"] .= "Cable/DSL";
    }
    if(@$data_to_store["corporate"] == 1)
    {
        if(@$data_to_store["connection_types"] != "")
            $data_to_store["connection_types"] .= ",";
        $data_to_store["connection_types"] .= "Corporate";
    }
    if(@$data_to_store["cellular"] == 1)
    {
        if(@$data_to_store["connection_types"] != "")
            $data_to_store["connection_types"] .= ",";
        $data_to_store["connection_types"] .= "Cellular";
    }
    unset($data_to_store["dialup"]);
    unset($data_to_store["cable"]);
    unset($data_to_store["corporate"]);
    unset($data_to_store["cellular"]);

    $times_range_to_exclude = "";
    for($i = 0; $i < 5; $i++)
    {
        if($data_to_store["times_range_to_exclude_from"][$i] != "00:00" || $data_to_store["times_range_to_exclude_to"][$i] != "00:00")
        {
            if($times_range_to_exclude != "")
                $times_range_to_exclude .= ",";
            $times_range_to_exclude .= $data_to_store["times_range_to_exclude_from"][$i]."-".$data_to_store["times_range_to_exclude_to"][$i];
        }
    }
    if($times_range_to_exclude != "")
        $data_to_store["times_range_to_exclude"] = $times_range_to_exclude;
    unset($data_to_store["times_range_to_exclude_from"]);
    unset($data_to_store["times_range_to_exclude_to"]);
    unset($data_to_store["hour"]);
    unset($data_to_store["minute"]);
    
    $db = getDbInstance();
    
    $last_id = $db->insert('sites', $data_to_store);

    if($last_id)
    {
    	$_SESSION['success'] = "Site added successfully!";
    	header('location: sites.php');
    	exit();
    }
    else
    {
        echo 'insert failed: ' . $db->getLastError();
        exit();
    }
}

//We are using same form for adding and editing. This is a create form so declare $edit = false.
$edit = false;

require_once 'includes/header.php'; 
?>
<div id="page-wrapper">
<div class="row">
     <div class="col-lg-12">
            <h2 class="page-header">Add Site</h2>
        </div>
        
</div>
    <form class="form" action="" method="post"  id="site_form" enctype="multipart/form-data">
       <?php  include_once('./forms/site_form.php'); ?>
    </form>
</div>


<script type="text/javascript">
$(document).ready(function(){
   $("#site_form").validate({
       rules: {
            domain: {
                required: true,
                minlength: 3
            }  
        }
    });
});
</script>

<?php include_once 'includes/footer.php'; ?>